﻿//===========================================================
//	Классы. Операции. Вложенность.
//===========================================================
#include "stdafx.h"
#include "MyString.h"
#include "MyVector.h"

// В проекте будут использованы класс Vector, инкапсулирующий 
// функциональность вектора на плоскости а также класс MyString.
// Поэтому подключите к проекту файлы Vector.h, Vector.cpp, MyString.h и MyString.cpp.

// Внимание: для header-файлов можно установить флажок "Exclude from build".
// Для этого можно воспользоваться диалогом Settings (вкладка General)

int main()
{
	//==========================
	// Переопределение операций
	//==========================

	// Рассмотрите реализацию операции присвоения (operator=) для класса Vector.
	// Объясните назначение условия if (this == &v).
		
	Vector a(2,1), b;
	
	cout << "\tTest Vector operator=\n";
	a.Out();		b.Out();
	
	// Вставьте код проверки операции=, присвоив объект a объекту b.
	
	// В пошаговом режиме с заходом в функции (F11)
	// просмотрите ход выполнения вашей, а также следующей операции
	a = a;
	stop
	
	// Почему работает следующий код, хотя операция присвоения не вызывается?
	// Убедитесь с помощью отладчика (точки останова).
	Vector c = a;
	
	c.Out();

	// Правильно. Здесь работает конструктор копирования (бесплатная версия).
	// Создайте свою, использующую вызов операции присвоения  ( *this = v; ).
	
	// Введите операцию присвоения в класс MyString и проверьте результат.
	// Для этого вам придется добавить в класс default-конструктор.
/*	
	MyString s("Dynamic strings always change their size");
	MyString str;

	str = s;
	
	cout << "\n\n\tTest MyString operator=\n\n" << str.GetString();
	stop
	
	// Вызывается ли эта операция в в этом фрагменте? Почему?
	MyString ss = s;
	
	// Создайте конструктор копирования, который действительно копирует текст
	// строки, а не запоминает ее адрес. Используйте существующие методы (Copy).

*/
	// Определите операцию сложения operator+() для объектов класса Vector
	// по правилам сложения векоторов на плоскости 
	// Напоминание: Одноименные координаты складываются.
	
	// Какая (кроме сложения) операция вызывается в следующем фрагменте.
	// В пошаговом режиме с заходом в функции (F11) просмотрите ход выполнения.

/*	cout << "\n\n\tTest Vector operator+\n";

	Vector d;
	d = a + b;

	d.Out();
	
	stop

	// Убедитесь, что конструктор копирования вызывается в этом фрагменте.
	Vector e = a + b;
	
	cout << "\n\n\tTest Vector copy constructor\n";
	e.Out();
*/	
	// В классе Vector определите унарную операцию (!) взятия модуля вектора.
	// Напоминание: Модуль - это длина вектора ( sqrt(x1*x1+ x2+x2); )
	// Проверьте корректность работы.
/*
	cout << "\n\n\tTest unary operator!() - \'vector length\'\n";
	cout << "\n |a| = " << !a;
	
	stop
*/
	// В классе Vector определите бинарные операции ">" и "==" так,
	// чтобы стали возможными следующие манипуляции с векторами
/*	
	if (e > a)
		cout << "\n\nVector e is greater than vector a\n";
	else if (e == a)
		cout << "\n Vector e is equal to vector a\n";
	else
		cout << "\n\nCould not compare vectors\n";

	// Отметьте, что векторы могут быть равными по модулю
	// и равными покомпонентно. Реализуйте второй вариант.
	
	// Внимание: Проверка равенства вещественных чисел всегда проводится
	// с какой-точностью. Например, fabs (x1 - x2) < DBL_EPSILON
	// Константа DBL_EPSILON == 2.2204460492503131e-016 определена в limits
	// Рекомендуется использовать ее при реализации operator==().
*/
	//==============================================
	// Определение операций с помощью friend-функций 
	//==============================================
	
	// Если мы хотим ввести в класс Vector операцию умножения вектора на скаляр
	// (v*d, где v - объект класса Vector, а d - скаляр типа double),
	// то мы можем это сделать 2-мя способами:
	
	// - в виде метода класса с одним параметром типа double, или
	// - в виде внешней функции с 2-мя параметрами.
	
	// Если же мы хотим умножать скаляры на векторы (d*v),
	// то это можно реализовать только одним способом (вторым).

	// Используйте оба способа при введении операции *.
	// При этом должны работать следующие строки кода.
/*
	cout << "\n\n\tTest operator*()\n";
	Vector v(1,2), w;
	w = 5. * v;
	w.Out();
	
	w = v * 5.;
	w.Out();
	
	w = 5 * v * atan(1.);
	w.Out();
*/	
	
	// В третий раз переопределите знак операции "*" в классе Vector
	// Реализуйте операцию скалярного произведения двух векторов
	// Обоснуйте ваш выбор способа реализации.

	//=============================================
	// Вложенность объектов и классов
	//=============================================
    
	// Создайте класс Rect, инкапсулирующий функциональность прямоугольника
	// с вещественными координатами. Он должен содержать два вложенных объекта
	// класса Vector, которые определяют координаты левого верхнего (ptLT) и
	// правого нижнего (ptRB) углов прямоугольника. Предусмотрите в конструкторе
	// (конструкторах) инициализацию встроенных объектов.

	// Подсказка: Вы можете создать новый класс с помощью студии.
	// В окне WorkSpace откройте вкладку ClassView, поставьте фокус
	// на элементе дерева <имя_проекта> classes и вызовите контекстное меню.
	// В нем выберите команду New Class... В диалоге задайте имя (Rect) нового
	// класса и нажмите OK. Cтудия введет в состав проекта два новых файла.
	// Просматривая коды заготовки, отметьте, что можно убрать некоторый лишний код.
	// Например, две директивы проверки версии #if _MSC_VER > 1000 и #endif // _MSC_VER > 1000
	
	// Введите в класс два объекта (ptLT, ptRB) класса Vector.
	
	// Снабдите класс конструкторами и операцией присвоения.
	// В частности, создайте конструктор с 4-мя параметрами, задающими координаты
	// 4-х границ (left, top, right, bottom) четырехугольника.
	
	// Совместите в классе 3 метода Inflate, которые позволят "надувать" четырехугольник.
	// 1. С одним параметром (по умолчанию = 1), который задает приращение всех 4-х границ.
	// 2. С 2-мя параметрами (приращение вширь и приращение ввер-вниз).
	// 3. С 4-мя параметрами (приращения, различные для всенх 4-х границ).

	// Добавьте метод Out() для вывода координат в таком виде: "Rect (10,10,50,30)"
	// В пошаговом режиме проследите последовательность вызова конструкторов
	// и операций при выполнении следующего кода
/*
	Vector v1 (1,1), v2 (101,101);
	
	Rect r (v1, v2);
	
	cout << "\n\n\tTest Rect\n";
	r.Out();
	
	r = Rect (10, 10, 50, 30);

	r.Out();

	r.Inflate();

	cout << "\n\n\tTest Inflate\n";
	r.Out();

	r.Inflate(2.5);
	r.Out();

	r.Inflate(-2.5, -2.5);
	r.Out();

	r.Inflate(1, 2, -3, 4);
	r.Out();
*/
	//=============================
	// Статические данные и функции
	//=============================
		
	// Введите в класс Vector статическую переменную private: int Count;
	// и статическую public-функцию PrintCount(), которая выводит значение
	// статической переменной Count. Например:
	
	// 	cout << "\n Now there are " << Count << " vectors";
	
	// Модифицируйте конструкторы так, чтобы каждый раз, когда создается
	// объект класса Vector, счетчик увеличивался на единицу
	// Реализуйте также отслеживание счетчиком гибели объектов.
	// Добейтесь корректного функционирования следующего фрагмента
/*	
	cout << "\n\n\tTest static members\n";
	
	Vector::PrintCount();	// Вызываем без помощи объекта
	
	Vector *pv = new Vector;
	
	pv->PrintCount();		// Вызываем с помощью объекта
	
	delete pv;
	Vector::PrintCount();	// Опять без помощи объекта

	Vector ar[4];
	ar->PrintCount();		// Опять с помощью объекта

	Vector *par[4];
		
	par[0] = new Vector(1,1);
	par[0]->Out();
		
	delete par[0];
*/
	// Для наглядности вы можете вставить вывод числа векторов в те
	// точки программы, где создаются и погибают объекты класса Vector,
	// и убедиться в том, что выведенное число объектов соответствует вашему учету.

	//=============================
	// Абстрактные классы
	//=============================
	
	// Сейчас вам следует создать простую иерархию классов.
	// Введите с помощью студии новый класс Shape.
	// Перенесите в него static-переменную Count и метод PrintCount,
	// удалив их полностью из класса Vector.

	// Введите в класс Shape массив указателей на объекты
	// static Shape* shapes[1000];
	
	// Лучше создать не массив, а динамический список указателей.
	// Те, кто чувствует себя вполне уверенно, могут реализовать
	// не массив, а динамический список адресов, но это сложнее.

	// Введите в класс Shape чисто виртуальные функции:
	
	// void Move (Vector& v);
	// void Out();
	// double Area(); 
	
	// Теперь конструктор класса Shape должен следить за своими детьми,
	// увеличивая или уменьшая счетчик объектов.
	// Не забудьте, что деструктор Shape тоже должен корректировать счетчик.
	// Заодно static-член класса Shape должен запоминать адреса созданных объектов
	// в массиве указателей (если счетчик не превышает 999).
					
	// Модифицируйте класс Rect. Сделайте его производным от Shape и
	// переопределите в нем все виртуальные функции класса Shape.

	// Пусть Move(Vector& v) - смещает прямоугольник на величину v,
	// Out() - уже существует (просто сделайте ее виртуальной)
	// Area() - выводит площадь прямоугольника
	
	// Класс Vector также сделайте производным от Shape.
	// Площадь точки равна нулю, поэтому Vector::Area() должен возвращать ноль.

	// Создайте новый класс Circle, производный от Shape. Очевидно, в нем должны быть
	// две переменные: Vector ptCntr; double R; и весь набор виртуальных функций.

	// С помощью следующего фрагмента проверьте корректность
	// функционирования Ваших классов.
/*
	cout << "\n\n\tTest abstract Shapes\n";
	{
		Rect* pr = new Rect(0, 0, 5, 5);	// In the heap
		Rect r (10, 10, 100, 100);			// On stack frame

		Circle* pc = new Circle (10, 10, 5);// In the heap
		Circle c (20, 20, 3);				// On stack frame
		Vector v (5.,5.);					// Смещение
		Shape::PrintCount();

		for (int i = 0; i<Shape::GetCount(); i++)
		{
			Shape* p = Shape::shapes[i];
			p->Move(v);
			p->Out();
			cout << ";  Area = " <<	p->Area();
		}
		Shape::PrintCount();
		delete pr;
		Shape::PrintCount();
		delete pc;
		Shape::PrintCount();
	}
	Shape::PrintCount();
*/	
	// Как показывает практика, самой сложной оказывается проблема
	// обеспечения видимости классов (читай - порядок директив #include)
	
	// Подсказка: Так как класс Shape является базовым, то везде, где была
	// директива #include "MyVector.h" теперь должны быть две директивы:
	
	// #include "MyShape.h"
	// #include "MyVector.h"
	
	// Так как класс Shape содержит упоминание вектора, т.е. строку:
	// virtual void Move (Vector& v) = 0;
	// то файл заголовков MyShape.h должен начинаться с упреждающего объявления:
	// class Vector;

	cout << "\n\n";
}

